@echo off
rem ESET PROTECT
rem Copyright (c) 1992-2023 ESET, spol. s r.o. All Rights Reserved

call :install_agent
goto :eof

rem __Function install_agent___
:install_agent
setlocal EnableDelayedExpansion

set product_uuid=

set http_proxy_hostname=
set http_proxy_port=
set http_proxy_username=
set http_proxy_password=

set "scriptDirectory=%~dp0"

:uniqInstallDirectoryLoop
set "installDirectory=%temp%\.eset-%RANDOM%%RANDOM%%RANDOM%"
if exist "%installDirectory%" goto :uniqInstallDirectoryLoop
md "%installDirectory%" 2>NUL

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
  if not defined PROCESSOR_ARCHITEW6432 (
    set IsArch_x86=true
  ) else (
    if "%PROCESSOR_ARCHITEW6432%" == "ARM64" (
      set IsArch_arm64=true
    )
  )
) else (
  if "%PROCESSOR_ARCHITECTURE%" == "ARM64" (
    set IsArch_arm64=true
  )
)

set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v12/12.5.2104.0/agent_x64.msi
set checksum=79fc024edcee1807594185be9cda93aa1c2555d5da2d5ca94eec5099085045b5
if defined IsArch_x86 (
  set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v12/12.5.2104.0/agent_x86.msi
  set checksum=508b74e6da3904bd3aa33ea9e8a835c57fcb81fe24d764b70076fd4de3148c73
)
if defined IsArch_arm64 (
  set url=http://repository.eset.com/v1/com/eset/apps/business/era/agent/v12/12.5.2104.0/agent_arm64.msi
  set checksum=925dee137476c071488066da5302e81e1c2bea7e7579695399ef6132bf8f47fa
)

rem Check if URL is empty and stop the script if it is
if "%url%"=="" (
  set platform=x64
  if defined IsArch_x86 (
    set platform=x86
  )
  if defined IsArch_arm64 (
    set platform=ARM64
  )
  echo Error: No installation package available for the detected platform: !platform!.
  endlocal
  exit /b 1
)

set "installConfigFile=%installDirectory%\install_config.ini"
echo.[ERA_AGENT_PROPERTIES] > "%installConfigFile%"
echo.P_INSTALL_MODE_EULA_ONLY=1 >> "%installConfigFile%"
echo.P_ENABLE_TELEMETRY=0 >> "%installConfigFile%"
echo.P_CONNECTION_CHOSEN=Host >> "%installConfigFile%"
echo.P_HOSTNAME=era.prazskyservis.it >> "%installConfigFile%"
echo.P_PORT=2222 >> "%installConfigFile%"
echo.P_INITIAL_STATIC_GROUP=MDAwMDAwMDAtMDAwMC0wMDAwLTcwMDEtMDAwMDAwMDAwMDAyAL2pBuJ/AACws7a7q1UAAAC9qQbifwAAsLO2u6tVAAAowvQXzJt4g4E4ErxdpgaNaLWNIQ== >> "%installConfigFile%"
echo.P_USE_PROXY=0 >> "%installConfigFile%"
echo.P_PROXY_HTTP_HOSTNAME= >> "%installConfigFile%"
echo.P_PROXY_HTTP_PORT= >> "%installConfigFile%"
echo.P_PROXY_HTTP_USERNAME= >> "%installConfigFile%"
echo.P_PROXY_HTTP_PASSWORD= >> "%installConfigFile%"
echo|set /p="P_CERT_CONTENT=" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="RYJv9GZofh4FjSdWox0aqJRZVPk1SAI177csnA0F60nK7rQkwGseYvou69nnUhBU/0BXRSc3WWK+2PxAKjEjz6ciV4jvcfk97dQoqRFQ7f/cyZkkheV0DHusn1ISEuE/KatmEUz7pAQ0ys7NgcU3XIjifEJ7jEkTXMLZEVa9ZtP/XSDNOrSsVp8NwW92cmeaynd/22YjAcsJQl3vtR/Wng+tSOsjMkt2iIOeNO2HYDlmZa5F/XGhVHKG1jU0HXlb//lpq6szvJDwIRwemO6Esuk9f3E1kD5Io8wVlUqUBkqA0ngPGAU9L6BZnnuvOjBseXhIJ13EYT0FhFs+6WhO3zSyBYsUTlg1PzElMCMGCSqGSIb3DQEJFTEWBBS8P0XaYssQTgsq4xjdp+i2MYNGCTBBMDEwDQYJYIZIAWUDBAIBBQAEIPGs0taOF4q1cE4WjusbpUV9jZPydvwPI9k8tZWmCH0hBAg9QjOgg5wNpgICCAA=" >> "%installConfigFile%"
echo. >> "%installConfigFile%"

echo.P_CERT_PASSWORD_IS_BASE64=yes >> "%installConfigFile%"
echo.P_CERT_PASSWORD= >> "%installConfigFile%"
echo.P_CERT_AUTH_CONTENT=MIIERTCCAq2gAwIBAgISAQt/RNSBNEyZvbJ2VX6QU4wBMA0GCSqGSIb3DQEBCwUAMDYxJzAlBgNVBAMMHlNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTELMAkGA1UEBhMCVVMwHhcNMjUwNjA4MjIwMDAwWhcNMzUwNjEwMjIwMDAwWjA2MScwJQYDVQQDDB5TZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxCzAJBgNVBAYTAlVTMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAwKdq5ONJ1IH3TN0qpDGkHOqhFwwKOezAkVwo1rYHw5uqAee9ohmNzltOMfgwkDDghr+8PCKSgRJNxQu6rjMcOCeZof+zvZRzztQMLVlCsiEz67g7gQO7Wjfq3bcOj+TqB9nssP8Wcz7eHsMsMVh1bBREtf1I95fE3X6n6xfOQIsK/YzK/Xhgw2Y81U23z0i7O+jmRM3k41BYBS+OwOfsZ2KwtBjpsmoYbgb482zWBAmXUNML1CknDW5LXffk2b02mSKA+PUSG1AT4kcq7DIw6URSH9oG6NWVaYdhbIRzS/+NHAxBKWxFZKPHMzsAl36boppd6mhCbgUx5ect+4OtxNZoKCzFiCuQEgzyDr2jw6JAOPLtUeDDLNKGbPa8nHp6d7yt4+3dt5RhZdq8pibDjIQJSAeGsGm9423d1kg43ZLE8HqsV3E9QkupWPhtRKYZsvcppCJJVtv3c355rTqW6gVtHpI+CElWKsdvVRE4Irt7L30pkfYuBybEojqInRWdAgMBAAGjTTBLMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBS7edOHatH+NZ2c/rg8k4ceDsaVUTAJBgNVHSMEAjAAMA0GCSqGSIb3DQEBCwUAA4IBgQBzAEjTYWUPH0Tv6E0oTVnRHVDETLjRPZ9qkhpq7+FjQtta2UGQW7se4ilZOA014bzlIQ7NmC3MQ9e7vSdfXXM54dWo0hB4wzVclgbRRpsLY9sghgXZqdFyn8z+wct7PZnrk0DDK0ZF3wkHLUgiw0XF545YchJE+AQ1sultv/1McFV2dL5LbXJIOgwh44nvuCOV9/0EleTVt6FDTqwr/ELkmOm50D9NRGPMrvteyp2848NlkD/ny2/+Kjg4Lfl48Hu/aKEYGNP5gjzxORjkLGDefNUznitX4VQFTBOwlmx+3XvqXywwySw09GnsKYaw92o7zEviFUfSjA+32ScSbzm+WXhbXXvKlJuN5K176IujsiYgmAS7C13Zh5BMasxfJ05xKfrxc+jxIyaGNwj+sKgeJ6Aru1u8KgUfLbNyE+3/HEsmD/qpGMtXlNZr3da46/knok3+/F9ukOsO6SGUKiPRQPAt/5swiJ02X6A1UBSS++0H/xkgzC44ebGGFw48Yuo= >> "%installConfigFile%"
echo|set /p="P_CUSTOM_POLICY=" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="dk1DQWdJQ0FnSUNBZ0lDQWdJQ0FnTVRjMk56Y3hORGt6TWlBZ01DQWdJQ0FnTUNBZ0lDQWdOalEwSUNBZ0lDQTBPRGtnSUNBZ0lDQWdZQXBkQUFBQ0FQLy8vLy8vLy8vL0FEMklpZ2N6OG13bnVWMVJFUGV1TGl3ZnJlK3RQZWlhOThBT2ZmZklzVStnU3BQcHdyNEMzeUJ0Tzh5Z1BOVUdxNzdKUmliUmxQd24xa1JpQkZsNFpEeCsvKzZ0Q281dzRyL2FHQW9VYlE1QTVzL1FSZC9XZ08xdWVGYit6aVJ4WjBXTm5sWGt3aWx4Z3hENk9waHUzQWZ5aHNwR3R0WXJod3RKR090TU0wNXdlRldlaE5NK05JdnQ1a2xGOG1Lc3g1UW9IU050SG0xNWlNWG1jNmoyM3dWQzVoai9iMktSTFczeWZpRjVMSTZQMm9ZZ3U2RmF6SUxzMEFxVGFYN2M5KzcxcSs4dUcwQ29WZ3ZtZVhxOHE0WUk1U08reTBsdExidG1NdDVncXRncTJJN25lSWVBMExNQUVtVFV0Nk13UWRFN1FNT1hra2psNG4rT3Zqa25oWEt5anRodU9WSU9GMEpIOVM2ejczaFhKRUE3aUl1UmVFUUt2OE5VTDZsTVhwTnN1UnllNXRoLzBVVVJFWDJQM1ptQ2JDdkhDWmdIbnN1bjhnOUlRbzBxY08wRm0yUXIzeldxbVZJLzZTUHpIWWtta1U1MFl1bnhRRFZQd1VyK1lqY1ZoVXdLTHRTUTdyMjVhNXZVRzBPazZFUmV6SXZNSncrVkg2NEI1cmVpcUNKRFdJV2V2SG1PbXQ1VXJOQ2FyL1JtOVpUNDdZL1I1eGNLYzFVYnYzbE1vajJRanlQVUF1V2JKNnRPQjVQZnJXU2lOaXlzSFViNG10NGZTVm52dTZWTSs4REJmUjBrVmpoalpaN1BSNzVnWjdlTWlqdFhyL3dWSVI0S2FXNW1ieTVxYzI5dUx5QWdJQ0FnSURFM05qYzNNVFE1TXpJZ0lEQWdJQ0FnSURBZ0lDQWdJRFkwTkNBZ0lDQWdOek1nSUNBZ0lDQWdJR0FLZXdvZ0luZHlhWFIwWlc1ZllubGZZMlVpT2lJeU1qQTJMamtnS0RJd01qVXhNakE1S1RzZ01qTTRNU0lzQ2lBaWQzSnBkR1ZmZEdsdGFXNW5JanBiTXl3d0xEQXNORjBLZlFvPQpleUp3YjJ4cFkza2lPbnNpWm05eWJXRjBJam94ZlgwS0lUeGhjbU5vUGdvdkx5QWdJQ0FnSUNBZ0lDQWdJQ0FnTVRjMk56Y3hORGt6T0NBZ01DQWdJQ0FnTUNBZ0lDQWdOalEwSUNBZ0lDQXpOU0FnSUNBZ0lDQWdZQXBtWldGMGRYSmxMa1Y0WTJ4MWMybHZibk5OWVc1aFoyVnRaVzUwTG14NmJXRXZDZ292TUNBZ0lDQWdJQ0FnSUNBZ0lDQWdNVGMyTnpjeE5Ea3pPQ0FnTUNBZ0lDQWdNQ0FnSUNBZ05qUTBJQ0FnSUNBeU56UWdJQ0FnSUNBZ1lBcGRBQUFDQVAvLy8vLy8vLy8vQUQySWlnY3o4bXdudVYxUkVQZXVMaXdmcmUrdFBlaWE5OEFPZmZmSXNVK2dTcFBwd3I0QzN5QnRPOHlnUE5VR3E3N0pSaWJSbFB3bjFrUmlCRmw0WkR4Ky8rNnRDbzV3NHIvYUdBb1ViUTVBNXMvUVJkL1dnTzF1ZUZiK3ppUnhaMFdObWxISlBrU0MxU3VYa2F2eEF4cnd0SUNYVHBIMGJwZDVLN29XOG42R1BiYkZVbDFCWGxFN3laR0x0TXBLdGM4UGV1U2tCb3hYZUhEMG1WZVRiQTJpV2VMOWxuZlVSSHJidjUvTHEreVhSbjRzeDNQMzZ4OTJseTdJOC9ZRmZRZnE0YjVhYWowbnRObU84YklFUnNnSUIxQUtPeGZHTzJrUFZleWRGYjlwclRUTnUyU3ROM29WdkJ3YzR3ek9lSnFLaHE4RzZxa2ZFOTBIUlVmeWN3UDd5bVdFYVc1bWJ5NXFjMjl1THlBZ0lDQWdJREUzTmpjM01UUTVNemdnSURBZ0lDQWdJREFnSUNBZ0lEWTBOQ0FnSUNBZ056TWdJQ0FnSUNBZ0lHQUtld29nSW5keWFYUjBaVzVmWW5sZlkyVWlPaUl5TWpBMkxqa2dLREl3TWpVeE1qQTVLVHNnTWpNNE1TSXNDaUFpZDNKcGRHVmZkR2x0YVc1bklqcGJOU3d3TERBc05WMEtmUW89CmV5SndiMnhwWTNraU9uc2labTl5YldGMElqb3hmWDBLSVR4aGNtTm9QZ292THlBZ0lDQWdJQ0FnSUNBZ0lDQWdNVGMyTnpjeE5URXhNaUFnTUNBZ0lDQWdNQ0FnSUNBZ05qUTBJQ0FnSUNBek5TQWdJQ0FnSUNBZ1lBcG1aV0YwZFhKbExrVjRZMngxYzJsdmJuTk5ZVzVoWjJWdFpXNTBMbXg2YldFdkNnb3ZNQ0FnSUNBZ0lDQWdJQ0FnSUNBZ01UYzJOemN4TlRFeE1pQWdNQ0FnSUNBZ01DQWdJQ0FnTmpRMElDQWdJQ0EyTURFZ0lDQWdJQ0FnWUFwZEFBQUNBUC8vLy8vLy8vLy9BRDJJaWdjejhtd251VjFSRVBldUxpd2ZyZSt0UGVpYTk4QU9mZmZJc1UrZ1NwUHB3cjRDM3lCdE84eWdQTlVHcTc3SlJpYlJsUHduMWtSaUJGbDRaRHgrLys2dENvNXc0ci9hR0FvVWJRNUE1cy9RUmQvV2dPMXVlRmIremlSeFowV05tbEhLUm9tWjRMeTlLVEpmMDkrU2l2UUM3SFZiNnZ3N1pNTlFWNzcxVDBQaS9CY1Y3Zy9SNmk4d0Fjcm5Wd2xPc2J5VStsUitWUkVhUUNiR01ZZ1JZNENFRGJlN2FCZmhLZ0FDVjFBNmJLWTFGOFRVYXpjeUdEZUYzV0I3ZHNldW1Bcy9YdXRsWU9JYUVMdzRaRWZ1cDJhS1VTTCtyN2NUQkdQVDNqeStodzhhaWlkc0QvbXEvSXlqVml0cmFTalRDdU9CK2lYUGM3dGhxYVFJREhITzNCZzhFR3pDSWMrVFcxYlhFOXcyejVqeEVYOTd3clZsdXNNSmZVb2p6NnhTVVRqYUMyM3V3VHRXTklHRjhhUmh6T042Wjc4Y0RQdWZCZWV3bFZsSFdSNU9WdktYL3VOWkNnNGcyUXFLRGU0N2ZCTlZKQjB3MkNhVWVJNW5BZjhwZWFtUklWQktGb3JiaEFiRE9qS1ZzSThDVHdkWjV1cEIrVGlOaGhpczg5dEIyd3ZERHF2a0taTHowZkkrRXRCMTlZR2tMOHAzWGdkMllxd3dsREFZbHZDMnNtZ1h5Uk5qYWpDbXNvOVRKVW5nOUtMeUdTYUFDdzZPT01aYTJYZTM4anVhZXliQUMrcjNPdHFoUmlORmhWSkRwRC9xVUk1SGttTFpvU0Y4V1FObWN3VGlyNWVxMzZwN2FSZjZyVFVMeUJMTTlFWjZCZ210KzdnQmRLWTdWVmVtcVI3NGJJc0xFTWEzL1NMY1doTGNSS3hrQ0sveFZEUmJXNmNxNjhDZHlsQnM0azh2V2R4MWxvSHZibFl2RE9YN1FlcmhtSjFGV2swYjZadlkraTI4UFZjUHRLdjk4bEQwQ21sdVptOHVhbk52Ymk4Z0lDQWdJQ0F4TnpZM056RTFNVEV5SUNBd0lDQWdJQ0F3SUNBZ0lDQTJORFFnSUNBZ0lEY3pJQ0FnSUNBZ0lDQmdDbnNLSUNKM2NtbDBkR1Z1WDJKNVgyTmxJam9pTWpJd05pNDVJQ2d5TURJMU1USXdPU2s3SURJek9ERWlMQW9nSW5keWFYUmxYM1JwYldsdVp5STZXelFzTUN3d0xEVmRDbjBLCmV5SndiMnhwWTNraU9uc2labTl5YldGMElqb3hmWDBLSVR4aGNtTm9QZ292THlBZ0lDQWdJQ0FnSUNBZ0lDQWdNVGMyTnpjeE5URXpNQ0FnTUNBZ0lDQWdNQ0FnSUNBZ05qUTBJQ0FnSUNBek5TQWdJQ0FnSUNBZ1lBcG1aV0Yw" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="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" >> "%installConfigFile%"
echo|set /p="MCAgICAgNjQ0ICAgICA0NiAgICAgICAgYAp7CiAid3JpdHRlbl9ieV9jZSI6IjIyMDYuOSAoMjAyNTEyMDkpOyAyMzgxIgp9" >> "%installConfigFile%"
echo. >> "%installConfigFile%"

for /f "tokens=2 delims=[]" %%G in ('ver') Do (set os_version=%%G)

for /f "tokens=2,3,4 delims=. " %%G in ('echo %os_version%') Do (set os_version_major=%%G& set os_version_minor=%%H& set os_version_build=%%I)

echo Installing ESET Management Agent...

> "%installDirectory%\uacinstall.vbs" (
echo.' ESET PROTECT
echo.' Copyright ^(c^) 1992-2023 ESET, spol. s r.o. All Rights Reserved
echo.
echo.Class CComputer
echo.    Private m_MACAddress
echo.    Private m_Parameters
echo.    Public Function Init^(MACAddress, Parameters^)
echo.        m_MACAddress = MACAddress
echo.        m_Parameters = Parameters
echo.        Set Init = Me
echo.    End Function
echo.    Public Property Get MACAddress
echo.        MACAddress = m_MACAddress
echo.    End Property
echo.    Public Property Get Parameters
echo.        Parameters = m_Parameters
echo.    End Property
echo.End Class
echo.
echo.Function GetCollectionCount^(collection^)
echo.    GetCollectionCount = 0
echo.    On Error Resume Next
echo.    GetCollectionCount = collection.Count
echo.End Function
echo.
echo.Function GetPackageName^(strLink^)
echo.    GetPackageName = Mid^(strLink, InStrRev^(strLink,"/"^) + 1, Len^(strLink^)^)
echo.End Function
echo.
echo.Function DownloadUsingHTTPProxy^(strLink, strProxyHostname, strProxyPort, strProxyUser, strProxyPassword^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = GetPackageName^(strLink^)
echo.    strSaveTo = "!installDirectory!" ^& "\" ^& strSaveName
echo.
echo.    Set objHTTP = CreateObject^("WinHttp.WinHttpRequest.5.1"^)
echo.    objHTTP.Open "GET", strLink, False
echo.    If Len^(strProxyHostname^) ^> 0 Then
echo.        objHttp.SetProxy 2, strProxyHostname ^& ":" ^& strProxyPort
echo.        If Len^(strProxyUser^) ^> 0 Then
echo.            const HTTPREQUEST_SETCREDENTIALS_FOR_PROXY = 1
echo.            objHTTP.SetCredentials strProxyUser, strProxyPassword, HTTPREQUEST_SETCREDENTIALS_FOR_PROXY
echo.        End If
echo.    End If
echo.    objHTTP.Send
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    If objHTTP.Status = 200 Then
echo.        Dim objStream
echo.        Set objStream = CreateObject^("ADODB.Stream"^)
echo.        With objStream
echo.            .Type = 1 'adTypeBinary
echo.            .Open
echo.            .Write objHTTP.ResponseBody
echo.            .SaveToFile strSaveTo
echo.            .Close
echo.        End With
echo.        Set objStream = Nothing
echo.    End If
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        DownloadUsingHTTPProxy = strSaveTo
echo.    End If
echo.End Function
echo.
echo.Function DropSHA256Tool^(^)
echo.    Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo.    strSaveName = "sha256sum.exe"
echo.    strSaveTo = "!installDirectory!" ^& "\" ^& strSaveName
echo.
echo.    If objFSO.FileExists^(strSaveTo^) Then
echo.        objFSO.DeleteFile^(strSaveTo^)
echo.    End If
echo.
echo.    Set oXML = CreateObject^("Msxml2.DOMDocument.3.0"^)
echo.    Set oNode = oXML.CreateElement^("base64"^)
echo.    oNode.dataType = "bin.base64"
echo.    oNode.text =               "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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"
echo.    oNode.text = oNode.text ^& "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                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             